# 画面設計書 1-Global Page

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のGlobal Page（Page ID: 0）の設計書である。Global Pageは全ページで共通して使用されるシステムページであり、アプリケーション全体で共有されるコンポーネントを定義する。

### 本画面の処理概要

Global Pageは、Oracle APEXにおける特殊なページであり、全ての通常ページに自動的にコンテンツが挿入される共有ページである。QUASTOアプリケーションでは、主にフッター領域にプロバイダースローガンを表示する目的で使用されている。

**業務上の目的・背景**：エンタープライズアプリケーションにおいて、全ページで一貫したブランディングや共通要素を表示することは、ユーザーエクスペリエンスの向上と企業アイデンティティの維持に不可欠である。Global Pageを使用することで、各ページに個別にコンポーネントを追加することなく、アプリケーション全体で統一されたフッター表示を実現している。

**画面へのアクセス方法**：Global Pageは直接アクセスする画面ではなく、他の全ての画面にコンテンツが自動挿入される。開発者は、APEX Application BuilderのPage 0を編集することでGlobal Pageの内容を変更できる。

**主要な操作・処理内容**：
1. フッター領域（REGION_POSITION_05）にProvider Sloganリージョンを表示
2. アプリケーション置換文字列「&PROVIDER_SLOGAN.」を参照してスローガン文字を動的に表示
3. フォントサイズはCSS変数「--ut-footer-apex-font-size」を参照（デフォルト0.75rem）

**画面遷移**：Global Page自体には画面遷移の概念はない。他の全ての画面（Dashboard、Rules、Login Pageなど）に自動的にコンテンツが継承される。

**権限による表示制御**：Global PageはProtection Level「D」（深い認証レベル）が設定されており、認証されたセッションでのみ内容が表示される。ただし、Login Page（公開ページ）など、認証前のページでも一部のコンテンツは表示される場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | グローバルフッター表示 | 主機能 | 全ページのフッター領域にプロバイダースローガンを表示 |

## 画面種別

システム共通ページ（Global Page）

## URL/ルーティング

- Page ID: 0
- エイリアス: なし
- 直接アクセス: 不可（他のページへの自動挿入のみ）

## 入出力項目

Global Pageにはページアイテム（入力項目）は定義されていない。

## 表示項目

| 項目名 | 表示位置 | 説明 | データソース |
|--------|----------|------|--------------|
| Provider Slogan | REGION_POSITION_05（フッター） | プロバイダースローガンテキスト | アプリケーション置換文字列「&PROVIDER_SLOGAN.」 |

## イベント仕様

Global Pageには動的アクション（Dynamic Action）やプロセスは定義されていない。表示のみの静的なコンテンツである。

## データベース更新仕様

### 操作別データベース影響一覧

Global Pageはデータベースへの操作を行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

Global Pageにはメッセージ表示機能は定義されていない。

## 例外処理

Global Pageには例外処理の定義はない。置換文字列「&PROVIDER_SLOGAN.」が未定義の場合は空文字として表示される。

## 備考

- Global Page（Page 0）はOracle APEX固有の機能であり、全ての通常ページに自動的にマージされる
- Provider Sloganリージョンはプラグインタイプ「Static Content」を使用
- CSS変数を使用したレスポンシブなフォントサイズ設定により、Universal Themeのスタイルガイドに準拠
- Autocomplete機能はセキュリティ上の理由からOFFに設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ページ定義を理解する

Oracle APEXのページ定義ファイルを読み、Global Pageの構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00000.sql | `src/apex/f141/application/pages/page_00000.sql` | Global Pageの基本設定とリージョン定義を理解 |

**読解のコツ**: Oracle APEX SQLファイルはPL/SQLブロックとして記述されており、`wwv_flow_imp_page.create_page`でページ設定、`wwv_flow_imp_page.create_page_plug`でリージョン定義が行われる。

#### Step 2: リージョン構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00000.sql | `src/apex/f141/application/pages/page_00000.sql` | Provider Sloganリージョンの設定を確認 |

**主要処理フロー**:
1. **行14-22**: `wwv_flow_imp_page.create_page`でページ基本設定（Protection Level: D）
2. **行23-35**: `wwv_flow_imp_page.create_page_plug`でProvider Sloganリージョン作成
3. **行31**: `p_plug_source`でHTMLコンテンツ定義（置換文字列&PROVIDER_SLOGAN.を含む）

### プログラム呼び出し階層図

```
Oracle APEX Engine
    |
    +-- wwv_flow_imp.component_begin (コンポーネント初期化)
    |
    +-- wwv_flow_imp_page.create_page (ページ定義)
    |
    +-- wwv_flow_imp_page.create_page_plug (リージョン定義)
           |
           +-- Provider Slogan (Static Content)
                  |
                  +-- &PROVIDER_SLOGAN. (置換文字列参照)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

アプリケーション         APEXエンジン                   フッター領域
置換文字列        ───>  置換文字列を                ───> Provider Slogan
(&PROVIDER_SLOGAN.)      HTMLに埋め込み                  テキスト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00000.sql | `src/apex/f141/application/pages/page_00000.sql` | ソース | Global Page定義 |
